/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.table.*;

import com.ice.util.AWTUtilities;


public class
DatabasePanel extends JPanel
		implements ActionListener, ItemListener, ChangeListener
	{
	private JButton			refreshButton;

	private JComboBox		dbList;
	private JTextArea		msgText;

	private MySQLAdapter	sqlAdapter;

	private boolean			isListFresh;


	public
	DatabasePanel()
		{
		this.isListFresh = false;
		this.setDoubleBuffered( true );
		this.establishContents();
		}

	public void
	stateChanged( ChangeEvent event )
		{
//	System.err.println( "stateChanged: " + event );
		JTabbedPane pane = (JTabbedPane) event.getSource();
		if ( pane.getSelectedComponent() == this )
			{
			if ( ! this.isListFresh )
				{
				this.refreshDatabaseList();
				}
			}
		}

	public void
	itemStateChanged( ItemEvent event )
		{
//	System.err.println( "itemStateChanged: " + event );
		if ( event.getStateChange() == ItemEvent.SELECTED )
			{
			String dbName = (String)
				this.dbList.getSelectedItem();

			this.setCurrentDatabase( dbName );
			}
		}

	public void
	setCurrentDatabase( String dbName )
		{
		SQLClientHandler handler =
			SQLClientHandler.getCurrentHandler();

		if ( handler == null )
			{
			this.showMessage
				( "INTERNAL ERROR: current handler is null." );
			return;
			}

		if ( ! handler.isOpen() )
			{
			this.showMessage
				( "INTERNAL ERROR: connection is not open." );
			return;
			}

		try {
			int rows = handler.performSQLUpdate( "use " + dbName );
			this.showMessage( "Database changed to '" + dbName + "'" );
			}
		catch ( SQLException ex )
			{
			this.showMessage
				( "SQLException: retrieving table information:\n"
					+ ex.getMessage() );
			}
		}

	public void
	refreshDatabaseList()
		{
		SQLClientHandler handler =
			SQLClientHandler.getCurrentHandler();

		if ( handler == null )
			{
			this.showMessage
				( "INTERNAL ERROR: current handler is null." );
			return;
			}

		if ( ! handler.isOpen() )
			{
			this.showMessage
				( "INTERNAL ERROR: connection is not open." );
			return;
			}

		try {
			String[] list =
				handler.getDatabaseList();

			this.dbList.removeAllItems();

			for ( int i = 0 ; i < list.length ; ++i )
				{
				this.dbList.addItem( list[i] );
				}

			this.isListFresh = true;
			}
		catch ( SQLException ex )
			{
			this.showMessage
				( "SQLException: retrieving table information:\n"
					+ ex.getMessage() );
			}
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "REFRESH" ) )
			{
			// UNDONE flush caches...
			this.refreshDatabaseList();
			}
		else
			{
			this.showMessage
				( "INTERNAL ERROR: unknown command: " + command );
			}
		}

	private void
	showMessage( String msg )
		{
		this.msgText.setText( msg );
		}

	private void 
	establishContents()
		{
		JLabel	lbl;
		int		row = 0;

		this.setLayout( new GridBagLayout() );
/*
		JPanel subpan = new JPanel();
		AWTUtilities.constrain(
			this, this.dbList,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, 0, 1, 1, 1.0, 1.0 );
*/
		this.dbList = new JComboBox();
		this.dbList.setEditable( false );
		this.dbList.addItemListener( this );
//		this.add( this.dbList, BorderLayout.CENTER );
		AWTUtilities.constrain(
			this, this.dbList,
			GridBagConstraints.NONE,
			GridBagConstraints.CENTER,
			0, 0, 1, 1, 0.0, 1.0 );

		this.msgText = new JTextArea();
//		this.add( this.msgText, BorderLayout.SOUTH );
		AWTUtilities.constrain(
			this, this.msgText,
			GridBagConstraints.HORIZONTAL,
			GridBagConstraints.SOUTH,
			0, 1, 1, 1, 1.0, 0.0 );
		}

	}


