#!/usr/bin/perl -w

use CGI;
use DBI;
require "genquery.pl";

$q=new CGI;
print $q->header,$q->start_html();
$debug=$q->param('debug');
if(!defined $debug) {$debug=0}
$table=$q->param('table');
dbOpen();

if(defined $q->param('submit')) {
#Submit has been pressed
	$userkey=$q->param('userkey');
	if(!(defined $userkey) || $userkey eq '') {
		print "<b>'Userkey'</b> is a required field. Enter any value known only to you ",
			"in order to protect your record from unauthorized updates";
		exit;
	}
	#check for duplicates
	$sql=GenWhere($q,"select * from ".$table);
	if($debug) {print "\nsql=",$sql,"\n";}
	dbExecute($sql);
	@fields=dbFetch();
	if(defined @fields) {
		print $q->h2("Record already exists, or is blank");
		exit;
	}
	$sql=GenInsert($q,$table);
	if($debug) {print "<br>\nsql=",$sql,"\n";}
	$count=dbDo($sql);
	dbClose();
	if($count==1) {
		print 'Record has been added successfully.  Use the <b>Back</b> button ',
			'on your browser or <a href="/cook">go back to home</a>';
	} else {
		print 'An error occurred - record has not been added';
	}
	exit;
}


#display blank form
printCenter($table.":Add new record");
print 'To go to Query form <a href=query.pl?table=',$table,'>click here</a>';
print "<p>",$q->start_form;
GenForm($debug,$table); #Generate a form from table structure
print "<p>",$q->submit('submit','Add new record');
print '<input type=hidden name=debug value="',$debug,'">';
print '<input type=hidden name=table value="',$table,'">';
print $q->end_form;
dbCloseCursor();
dbClose();
exit;

