/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Inv2i;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import com.sun.electric.tool.generator.layout.gates.WellTie;
import java.util.ArrayList;

public class Nand2PHfk {
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    public static Cell makePart(double sz, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        EditingPreferences ep = stdCell.getEditingPreferences();
        String nm = "nand2PHfk";
        sz = stdCell.roundSize(sz);
        Cell nand = stdCell.findPart(nm, sz = stdCell.checkMinStrength(sz, 1.0, nm));
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        String vddName = stdCell.getVddExportName();
        String gndName = stdCell.getGndExportName();
        PortCharacteristic vddRole = stdCell.getVddExportRole();
        PortCharacteristic gndRole = stdCell.getGndExportRole();
        NodeInst inv2i = LayoutLib.newNodeInst(Inv2i.makePart(sz, stdCell), ep, 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        NodeInst pms1 = LayoutLib.newNodeInst(Pms1.makePart(sz, stdCell), ep, 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        NodeInst invK = LayoutLib.newNodeInst(Inv.makePart(sz / 10.0, stdCell), ep, 0.0, 0.0, -1.0, 1.0, 0.0, nand);
        NodeInst inv1 = LayoutLib.newNodeInst(Inv.makePart(1.0, stdCell), ep, 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        ArrayList<NodeInst> l = new ArrayList<NodeInst>();
        l.add(inv2i);
        l.add(pms1);
        l.add(invK);
        l.add(inv1);
        LayoutLib.abutLeftRight(l);
        Cell tieCell = WellTie.makePart(true, false, pms1.getBounds().getWidth(), stdCell);
        NodeInst tie = LayoutLib.newNodeInst(tieCell, ep, 0.0, 0.0, 1.0, 1.0, 0.0, nand);
        LayoutLib.abutLeftRight(inv2i, tie);
        l.add(tie);
        TrackRouterH vdd = new TrackRouterH(tech.m2(), 10.0, tech, ep, nand);
        vdd.connect(l, vddName);
        TrackRouterH gnd = new TrackRouterH(tech.m2(), 10.0, tech, ep, nand);
        gnd.connect(l, gndName);
        TrackRouterH out = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, ep, nand);
        out.connect(new PortInst[]{inv2i.findPortInst("out"), pms1.findPortInst("d"), invK.findPortInst("out"), inv1.findPortInst("in")});
        TrackRouterH k = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, ep, nand);
        k.connect(new PortInst[]{invK.findPortInst("in"), inv1.findPortInst("out")});
        Export.newInst(nand, inv2i.findPortInst("in[p]"), "inb", ep).setCharacteristic(PortCharacteristic.IN);
        Export.newInst(nand, inv2i.findPortInst("in[n]"), "resetN", ep).setCharacteristic(PortCharacteristic.IN);
        Export.newInst(nand, pms1.findPortInst("g"), "ina", ep).setCharacteristic(PortCharacteristic.IN);
        Export.newInst(nand, inv2i.findPortInst("out"), "out", ep).setCharacteristic(PortCharacteristic.OUT);
        Export.newInst(nand, inv2i.findPortInst(vddName), vddName, ep).setCharacteristic(vddRole);
        Export.newInst(nand, inv2i.findPortInst(gndName), gndName, ep).setCharacteristic(gndRole);
        stdCell.addEssentialBounds(0.0, inv1.getBounds().getMaxX(), nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

