/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.fill;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.fill.FillCell;
import com.sun.electric.tool.generator.layout.fill.FillGenConfig;
import com.sun.electric.tool.generator.layout.fill.FillRouter;
import com.sun.electric.tool.generator.layout.fill.Floorplan;
import com.sun.electric.tool.generator.layout.fill.G;
import com.sun.electric.util.math.DBMath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TiledCell {
    private int vddNum;
    private int gndNum;
    private Cell tileCell;
    protected FillGenConfig config;
    protected final EditingPreferences ep;
    private static final Orientation[] horizontalPlan = new Orientation[]{Orientation.VERT_EXTERIOR, Orientation.HORI_EXTERIOR, Orientation.INTERIOR};
    private static final Orientation[] verticalPlan = new Orientation[]{Orientation.HORI_EXTERIOR, Orientation.VERT_EXTERIOR, Orientation.INTERIOR};

    private String vddName() {
        int n;
        return (n = this.vddNum++) == 0 ? "vdd" : "vdd_" + n;
    }

    private String gndName() {
        int n;
        return (n = this.gndNum++) == 0 ? "gnd" : "gnd_" + n;
    }

    public TiledCell(FillGenConfig conf, EditingPreferences ep) {
        assert (conf != null);
        this.config = conf;
        this.ep = ep;
    }

    private TiledCell(int numX, int numY, Cell cell, Floorplan[] plans, Library lib, EditingPreferences ep) {
        this.ep = ep;
        String tiledName = "t" + cell.getName() + "_" + numX + "x" + numY + "{lay}";
        this.tileCell = Cell.newInst(lib, tiledName);
        this.config = new FillGenConfig(cell.getTechnology());
        Rectangle2D bounds = cell.findEssentialBounds();
        ERectangle r = cell.getBounds();
        Job.error(bounds == null, "missing Essential Bounds");
        double cellW = bounds.getWidth();
        double cellH = bounds.getHeight();
        double y = 0.0;
        NodeInst[][] rows = this.newRows(numX, numY);
        for (int row = 0; row < numY; ++row) {
            double x = 0.0;
            for (int col = 0; col < numX; ++col) {
                rows[row][col] = LayoutLib.newNodeInst(cell, ep, x, y, G.DEF_SIZE, G.DEF_SIZE, 0.0, this.tileCell);
                x += cellW;
            }
            y += cellH;
        }
        TiledCell.connectAllPortInsts(this.config.getTechType(), ep, this.tileCell);
        this.exportUnconnectedPortInsts(rows, plans[plans.length - 1].horizontal, this.tileCell);
        this.addEssentialBounds1(r.getX(), r.getY(), cellW, cellH, numX, numY, this.tileCell);
    }

    public static ArrayList<PortInst> connectAllPortInsts(TechType tech, EditingPreferences ep, Cell cell) {
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                ports.add(pi);
            }
        }
        Collections.sort(ports, new OrderPortInstsByName());
        FillRouter.connectCoincident(tech, ep, ports);
        return ports;
    }

    private static Orientation orientation(Rectangle2D bounds, PortInst pi) {
        EPoint center = pi.getCenter();
        double portX = center.getX();
        double portY = center.getY();
        double minX = bounds.getMinX();
        double maxX = bounds.getMaxX();
        double minY = bounds.getMinY();
        double maxY = bounds.getMaxY();
        if (DBMath.areEquals(portX, minX) || DBMath.areEquals(portX, maxX)) {
            return Orientation.VERT_EXTERIOR;
        }
        if (DBMath.areEquals(portY, minY) || DBMath.areEquals(portY, maxY)) {
            return Orientation.HORI_EXTERIOR;
        }
        return Orientation.INTERIOR;
    }

    private static ArrayList<PortInst> getUnconnectedPortInsts(List<Orientation> orientationList, NodeInst ni) {
        Rectangle2D bounds = ni.findEssentialBounds();
        if (bounds == null) {
            bounds = ni.getBounds();
        }
        ArrayList<PortInst> ports = new ArrayList<PortInst>();
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            Orientation or;
            PortInst pi = it.next();
            if (pi.hasConnections() || !orientationList.contains((Object)(or = TiledCell.orientation(bounds, pi)))) continue;
            ports.add(pi);
        }
        return ports;
    }

    private void exportPortInsts(List<PortInst> ports, Cell tiled) {
        Collections.sort(ports, new OrderPortInstsByName());
        for (PortInst pi : ports) {
            Export e;
            PortProto pp = pi.getPortProto();
            PortCharacteristic role = pp.getCharacteristic();
            if (role == FillCell.VDD_CHARACTERISTIC) {
                e = Export.newInst(tiled, pi, this.vddName(), this.ep);
                e.setCharacteristic(role);
                continue;
            }
            if (role == FillCell.GND_CHARACTERISTIC) {
                e = Export.newInst(tiled, pi, this.gndName(), this.ep);
                e.setCharacteristic(role);
                continue;
            }
            Job.error(true, "unrecognized Characteristic");
        }
    }

    public void exportUnconnectedPortInsts(NodeInst[][] rows, boolean isPlanHorizontal, Cell tiled) {
        Orientation[] orientations = isPlanHorizontal ? horizontalPlan : verticalPlan;
        ArrayList<Orientation> list = new ArrayList<Orientation>();
        for (int o = 0; o < 3; ++o) {
            int numRows = rows.length;
            list.clear();
            list.add(orientations[o]);
            Orientation orientation = orientations[o];
            for (int row = 0; row < numRows; ++row) {
                int numCols = rows[row].length;
                for (int col = 0; col < numCols; ++col) {
                    if (orientation == Orientation.INTERIOR && row != col) continue;
                    ArrayList<PortInst> ports = TiledCell.getUnconnectedPortInsts(list, rows[row][col]);
                    this.exportPortInsts(ports, tiled);
                }
            }
        }
    }

    private NodeInst[][] newRows(int numX, int numY) {
        NodeInst[][] rows = new NodeInst[numY][];
        for (int row = 0; row < numY; ++row) {
            rows[row] = new NodeInst[numX];
        }
        return rows;
    }

    private void addEssentialBounds1(double x, double y, double cellW, double cellH, int numX, int numY, Cell tiled) {
        double x2 = x + (double)numX * cellW;
        double y2 = y + (double)numY * cellH;
        TechType tech = this.config.getTechType();
        LayoutLib.newNodeInst(tech.essentialBounds(), this.ep, x, y, G.DEF_SIZE, G.DEF_SIZE, 180.0, tiled);
        LayoutLib.newNodeInst(tech.essentialBounds(), this.ep, x2, y2, G.DEF_SIZE, G.DEF_SIZE, 0.0, tiled);
    }

    public static Cell makeTiledCell(int numX, int numY, Cell cell, Floorplan[] plans, Library lib, EditingPreferences ep) {
        TiledCell tile = new TiledCell(numX, numY, cell, plans, lib, ep);
        return tile.tileCell;
    }

    private static class OrderPortInstsByName
    implements Comparator<PortInst> {
        private OrderPortInstsByName() {
        }

        private String base(String s) {
            int under = s.indexOf("_");
            if (under == -1) {
                return s;
            }
            return s.substring(0, under);
        }

        private int subscript(String s) {
            int under = s.indexOf("_");
            if (under == -1) {
                return 0;
            }
            String num = s.substring(under + 1, s.length());
            return Integer.parseInt(num);
        }

        @Override
        public int compare(PortInst p1, PortInst p2) {
            String base2;
            String n1 = p1.getPortProto().getName();
            String n2 = p2.getPortProto().getName();
            String base1 = this.base(n1);
            if (!base1.equals(base2 = this.base(n2))) {
                return n1.compareTo(n2);
            }
            int sub1 = this.subscript(n1);
            int sub2 = this.subscript(n2);
            return sub1 - sub2;
        }
    }

    private static enum Orientation {
        VERT_EXTERIOR,
        HORI_EXTERIOR,
        INTERIOR;

    }
}

